/*
	Demonstrating "2D-compositing.inc"
	Use this with POV-Ray 3.5 or above.
		
	Please note: Don't use anti-alias when rendering this, unless
	you want to soften the look of the original images.

	Please run with these INI settings:

	+W640 +H480 +KFF10	
*/

#include "2D-compositing.inc"

// At least 2 images needed for this to work:
#declare Image_1=function { pigment { image_map { jpeg "TestImage_1.jpg" } } }; // you can use "interpolate 2" if you plan to resize before rendering
#declare Image_2=function { pigment { image_map { jpeg "TestImage_2.jpg" } } };

#declare Pixels_To_Move = <-10,0>; // Moving the alpha map

#declare Alpha_Col_1= clock;
#declare Alpha_Col_2= min( 1, clock*2 );

#declare Image_3=function { pigment { gradient x
		pigment_map {
			[ 0  rgb Alpha_Col_1 ] [ .5 rgb Alpha_Col_2 ] [ 1 rgb Alpha_Col_1 ]
		}
		scale One_Pixel*7 // Size of lines
		rotate -13*z
		translate (One_Pixel*Pixels_To_Move)*clock
	}
};

// Their resolutions must be specified manually:
#declare Image_1_Resolution = <640,300>;
#declare Image_2_Resolution = <640,300>;
#declare Displayed_Resolution = <640,300>; // For the result

// Choose the blending mode. You can read about the available modes in the file "2D-compositing.inc"
#declare Percent = clock;  // Percent ranges from 0-1 (for example: 0.5 blend the images by 50%) 
#declare Position = <0,100>; // You can specify the screen pixel position where the result will be displayed

Blend_Alpha( Image_1, Image_2, Image_3 )
 